import numpy as np


def mat_vec(A_mat):
    return (A_mat.T).reshape(-1,1)

def vec_mat(A_vec, p_dim):
    return (A_vec.reshape(p_dim,p_dim)).T

def get_var_AR(A_mat, p_dim, d_dim, Sigma):
    dim = p_dim*d_dim
    Phi_mat = np.zeros((dim,dim))
    for it in range(d_dim):
        Phi_mat[0:p_dim,(it*p_dim):((it+1)*p_dim)] = A_mat[:,(it*p_dim):((it+1)*p_dim)]
    for it in np.arange(1,d_dim,1):
        Phi_mat[(it*p_dim):((it+1)*p_dim),((it-1)*p_dim):(it*p_dim)] = np.identity(p_dim)
    PhiPhi = np.kron(Phi_mat, Phi_mat)
    Sigma_aug = np.zeros((dim,dim))
    Sigma_aug[0:p_dim,0:p_dim] = Sigma
    var_AR_vec = np.dot(np.linalg.inv(np.identity(dim**2) - PhiPhi),mat_vec(Sigma_aug))
    var_AR = vec_mat(var_AR_vec, dim)
    return var_AR
    
def ts_iid(A_mat, p_dim, d_dim, Sigma, time_len):
    var_AR = get_var_AR(A_mat, p_dim, d_dim, Sigma)
    return np.random.multivariate_normal(np.zeros(p_dim), var_AR[0:p_dim,0:p_dim], size=time_len)
